% Author: Layla S. Mayboudi
% 2021-05-27
% This code creates a rectangular geometry, embedding three circle
% and a tetramesh element using a given mesh grid.


clear all; clc; clf; close all;

rect = [3 4 -1 1 1 -1 0 0 -0.5 -0.5]';
C1 = [1 1 -0.25 0.25]';
C2 = [1 -1 -0.25 0.25]';
C3 = [1 0 -0.25 0.25]';
C1 = [C1;zeros(length(rect) - length(C1),1)];
C2 = [C2;zeros(length(rect) - length(C2),1)];
C3 = [C3;zeros(length(rect) - length(C3),1)];
gd = [rect,C1,C2,C3];
ns = char('rect1','C1','C2','C3');
ns = ns';
sf = '(rect1+C1)+C2+C3';
figure(1);
[dl,bt] = decsg(gd,sf,ns);
pdegplot(dl,'EdgeLabels','on','FaceLabels','on')
xlim([-1.5,1.5]); ylim([-0.5 0]); ax = gca; ax.FontSize = 10;
axis equal

figure(2);
d = [-5 5];
[x,y,z] = meshgrid(d,d,d);
x=[x(:);0];
y=[y(:);0];
z=[z(:);0];
dt = delaunayTriangulation(x,y,z);
Tes = dt(:,:);
X=[x(:) y(:) z(:)];
tetramesh(Tes,X);camorbit(20,0)